/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.tracker;

import filenet.vw.apps.tracker.VWTrackerCore;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWSplashWindow;
import java.net.URL;
import javax.swing.JOptionPane;

public class VWTrackerApplet
extends VWBaseAppLauncherApplet
implements IVWSplashWindowListener {
    private VWSplashWindow m_splashWindow = null;
    private VWTrackerCore m_trackerCore = null;

    public void init() {
        String trackerCodeBase = null;
        URL codebase = null;
        String title = null;
        try {
            super.init();
            this.m_splashWindow = new VWSplashWindow(null);
            title = VWIDMBaseFactory.instance().getVWString(6).toString();
            trackerCodeBase = this.getParameter("trackerCodeBase");
            if (trackerCodeBase != null) {
                codebase = new URL("http", this.m_sessionInfo.getProperty("hostName"), trackerCodeBase);
            }
            if (codebase != null) {
                IVWIDMFactoryProperties properties = VWIDMBaseFactory.instance().getProperties();
                properties.setProperty("hostName", this.m_sessionInfo.getProperty("hostName"));
                properties.setProperty("baseURL", codebase.toString());
                properties.setProperty("applet", null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            this.setEnabled(false);
            this.setVisible(false);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), title, 0, null);
            this.abort();
        }
    }

    public void start() {
        if (this.m_splashWindow != null) {
            this.m_splashWindow.start(this, 250);
        }
    }

    public void destroy() {
        try {
            if (this.m_splashWindow != null) {
                this.m_splashWindow.setVisible(false);
            }
            if (this.m_trackerCore != null) {
                if (this.isActive()) {
                    this.m_trackerCore.doExit();
                }
                this.m_trackerCore = null;
            }
            super.destroy();
            System.runFinalization();
            System.gc();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        if (this.m_trackerCore != null) {
            return;
        }
        try {
            if (!this.m_sessionInfo.verifyLogon(null)) {
                this.abort();
                return;
            }
            if (this.m_splashWindow != null) {
                this.m_splashWindow.show();
            }
            this.m_trackerCore = new VWTrackerCore();
            this.m_trackerCore.setSplashWindow(this.m_splashWindow);
            this.m_trackerCore.init(this.m_sessionInfo);
            this.m_trackerCore.setSplashWindow(null);
            this.m_splashWindow = null;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void childWindowClosed() {
        if (this.m_trackerCore != null) {
            this.m_trackerCore.refresh();
        }
    }

    protected void abort() {
        super.abort();
    }
}

